#ifndef APRIORI_H
#define APRIORI_H

#include "ATrie.hpp"
#include <map>

class Apriori {
public:

   Apriori( ifstream& basket_file, const char* output_file_name, 
      const bool store_input ):
      iom(basket_file, output_file_name ),
      store_input(store_input){}

   /// This procedure implements the APRIORI algorithm
   void APRIORI_alg( const double min_supp, 
		     const bool quiet, const countertype size_threshold );
    ~Apriori(){delete apriori_trie;}
private:

   /// Determines the support of the candidates of the given size
   void support( const itemtype& candidate_size );

protected:
   // No protected class data members

private:
   /// A trie that stores the candidates.
   ATrie*                           apriori_trie;

   /// The iom that is responsible for the input, 
   /// output and recoding operations.
   iom                    iom;

   /// This will store the reduced baskets, if store_input=true;
   map<vector<itemtype>, countertype>    reduced_baskets;

   /// If store_input = true, then the reduced baskets 
   /// will be stored in memory
   bool                                    store_input;
};

#endif
